{
	debug_skipBridge [0]
	debug_detachTruck [0]
	debug_skipToPlanes[0]
	debug_spam [0]

	saved_yet [0]
	saved_onload [0]
	saved_AtWaveTrigger01 [0]
	saved_AtBridge [0]
	saved_AtFinalEscape [0]
	saved_Bridge_NumShot [0]
	saved_Bridge_NumSpawn [0]
	saved_Bridge_NumEnd [0]
	saved_Bridge_LastPath [0]
	saved_EnableFinalWave [0]
	saved_Occupied1 [0]
	saved_Occupied2 [0]
	saved_Occupied3 [0]
	saved_Occupied4 [0]
	saved_Occupied5 [0]
	saved_NumPacks [0]
	saved_CurBike [0]
	saved_NumDeadPlanes [0]
	saved_NumBombWaves [0]
	saved_EnableEscape [0]
	saved_IsCrouching [0]

	Bridge_MaxSpawn [9]
	Bridge_MaxEnd [2]
	MaxPacks [10]

	saved_IsPlaying_TruckDrive [0]

	Init[ ()
	{
		GetPlayer().SetWalking();

		SetVis_RayLen( 48 ); 	// default is 32
		SetVis_RayWidth( 96 );	// default is 256

		if( saved_yet = 0 )
		{
			saved_yet = 1;

			// Get to the Airfield
			AddObjective( 183, 6000,44544 );
			SetObjectiveActive( 0, true );

			//Defend the Bridge
			AddObjective( 184, 20832, 20592 );
			SetObjectiveActive( 1, false );

			// Get to the Airfield
			AddObjective( 183, 6000,44544 );
			SetObjectiveActive( 2, false );

			// Use AA to provide cover
			AddObjective( 185, 6000,44544 );
			SetObjectiveActive( 3, false );

			// Make final escape
			AddObjective( 186, 5136, 44448 );
			SetObjectiveActive( 4, false );

			GetPlayer().SetNationality(2);
			GetPlayer().GiveWeapon(44,12);  // Bren
			GetPlayer().SetInvulnerable( false );

			flyboy = GetEntity("pEscape");
			flyboy.ShowEntity( false );
			flyboy.SetPassable( true );

			if( debug_detachTruck = 0 )
			{
				GetPlayer().SetFrozen(true);
			}

			AutoSave();
		}
	}]

	OnLevelLoad[ ()
	{
		PlayAmbient( 125 );
		ourRide = GetEntity("rTruck1");

		if( saved_onload = 0 )
		{
			saved_onload = 1;

			if( debug_skipToPlanes = 1 )
			{
				ourRide.SetPosition(6124,44430,-4160);
				ourRide.SetRotationTurn(16041);
				ourRide.StartBombers();

				saved_AtWaveTrigger01 = 1;
				saved_EnableFinalWave = 1;
				SpawnFinalWave("all");
				SpawnBomberWave();
				GetEntity("sarge").SetAttackDistance(64,10);
			}
			else
			{
				ourRide.DriveToBridge();
				ourRide.PlaySound( 126,100, 1, 255 );
				saved_IsPlaying_TruckDrive = 1;
			}
		}

		if( saved_IsPlaying_TruckDrive = 1 )
		{
			ourRide.PlaySound( 126,100, 1, 255 );
			return;
		}

		if( saved_IsCrouching = 1 )
		{
			GetPlayer().SetCrouching();
		}
	}]

	EnterZone[ (zone)
	{
		if( zone="CrouchDown" )
		{
			GetPlayer().SetCrouching();
			saved_IsCrouching = 1;
			return;
		}
		if( zone="StandUp" )
		{
			GetPlayer().SetRunning();
			saved_IsCrouching = 0;
			return;
		}

		if( zone="WaveTrigger01" )
		{
			if( saved_AtWaveTrigger01 = 0 )
			{
				saved_AtWaveTrigger01 = 1;
				saved_EnableFinalWave = 1;
				SpawnBomberWave();
				ObjectiveComplete(2);
				SetObjectiveActive( 3, true );
			}
			return;
		}

		if( zone="gDrive01" )
		{
			gRide = GetEntity("gTruck1");
			gRide.DriveToBridge();
			return;
		}

		if( zone="gDrive02" )
		{
			saved_CurBike = 1;

			gRide = GetEntity("gMoto1");
			gRide.FollowPath("gDrive02");
			gRide.FollowPathCallback(127, "FollowPath", "rDrive02b" );
			return;
		}
		if( zone="gDrive03" )
		{
			gRide = GetEntity("gTruck2");
			gRide.DriveToTunnel();
			return;
		}
		if( zone="gDrive04" )
		{
			saved_CurBike = 2;
			gRide = GetEntity("gMoto2");
			gRide.FollowPath("rDrive04a");
			gRide.FollowPathCallback( 127, "FollowPath", "rDrive04b" );
			return;
		}
		if( zone="FinalEscape" )
		{
			if( saved_EnableEscape = 1 )
			{
				if( saved_AtFinalEscape = 0 )
				{
					saved_AtFinalEscape = 1;

					ObjectiveComplete(4);

					truck = GetEntity( "rTruck1" );
					truck.SetModel(93);
					truck.PutInReverse( false );
					truck.PlaySound( 126,100, 1, 255 );
					saved_IsPlaying_TruckDrive = 1;

					Sgt = GetEntity("sarge");
					Sgt.StopTurnTo();
					Sgt.SetCrouching();
					Sgt.AttachTo( truck, 5 );
					Sgt.SetBaseRotation(0,0,180);
					Sgt.PlayAnimation(8); // idle crouch

					truck.SetState_TruckDrive(4);
					truck.FollowPath( "TruckEscape" );
					truck.FollowPathCallback( 127, "GameOver" );

					flyboy = GetEntity("pEscape");
					flyboy.SetNationality(2);
					flyboy.ShowEntity( true );
					flyboy.SetInvulnerable( true );
					flyboy.SetSpeed(2);
					flyboy.WalkTo(10064,49040);
				}
			}
			return;
		}
	}]

	ActorKilled[ (name, obj)
	{
		if( saved_AtBridge = 1 )
		{
			Spew("DEATH:  " # name );
			if( (name="dude0") or (name="dude1") or (name="dude2") or (name="dude3") or (name="dude4") or (name="dude5") or (name="dude6") or (name="dude7") or (name="dude8") or (name="dude9") )
			{
				saved_Bridge_NumShot = toInt(saved_Bridge_NumShot + 1 );
				Spew("        NumShot:  " # saved_Bridge_NumShot);
				if( saved_Bridge_NumShot > 6 )
				{
					Spew("        *** Bridge Objective Completed ***");
					// clear mission fail counter first
					saved_Bridge_NumEnd = 0;

					Sgt = GetEntity("sarge");
					Sgt.ReturnToTruck();
				}
			}
			return;
		}

		if( (name="eb01") or (name="eb02") or (name="eb03") or (name="eb04") or (name="eb05") )
		{
			vacant = obj.saved_idtag;
			switch(vacant)
			{
				case 1 { saved_Occupied1 = 0;  }
				case 2 { saved_Occupied2 = 0;  }
				case 3 { saved_Occupied3 = 0;  }
				case 4 { saved_Occupied4 = 0;  }
				case 5 { saved_Occupied5 = 0;  }
			}

			//SpawnFinalWave( obj.saved_idtag );
			return;
		}

		if( name="mDriver" )
		{
			BlowMoto();
			return;
		}

		if( name="gPlane" )
		{
			Spew("   *** gPlane killed ***");
			saved_NumDeadPlanes = toInt( saved_NumDeadPlanes + 1 );
			CheckBomberRunOver();
		}
	}]

	BlowMoto[ (which)
	{
		Spew("--> BlowMoto()");

		if( saved_CurBike = 1 )
		{
			bike = GetEntity("gMoto1");
		}else{
			bike = GetEntity("gMoto2");
		}

		bike.StopFollowingPath();
		bike.DoFireExplosionEffect();

		rider = GetEntity( "mPass" );
		if( isObject(rider) )
		{
			if ( not rider.IsDead() )
			{
				rider.Kill();
			}
	}
		Spew("   <-- BlowMoto()");
	}]

	SpawnFinalWave[ (which)
	{
		Spew("--> SpawnFinalWave(" # which # ")");
		if (saved_EnableFinalWave = 1 )
		{
			Spew("        enabled:  1");
			switch( which )
			{
				case "all"
				{
					SpawnFinalWave(1);
					SpawnFinalWave(2);
					SpawnFinalWave(3);
					SpawnFinalWave(4);
					SpawnFinalWave(5);
					return;
				}
				case 1
				{
					if( saved_Occupied1 = 0 )
					{
						Spew("        Go 1");

						me = GetEntity("eb01");
						me.saved_mypath = "endBattle01";
						me.saved_idtag = 1;
						me.Delay( 5, 10 );
						saved_Occupied1 = 1;
					}
					return;
				}
				case 2
				{
					if( saved_Occupied2 = 0 )
					{
						Spew("        Go 2");

						me = GetEntity("eb02");
						me.saved_mypath = "endBattle02";
						me.saved_idtag = 2;
						me.Delay( 8, 10 );
						saved_Occupied2 = 1;
					}
					return;
				}
				case 3
				{
					if( saved_Occupied3 = 0 )
					{
						Spew("        Go 3");

						me = GetEntity("eb03");
						me.saved_mypath = "endBattle03";
						me.saved_idtag = 3;
						me.Delay( 6, 10 );
						saved_Occupied3 = 1;
					}
					return;
				}
				case 4
				{
					if( saved_Occupied4 = 0 )
					{
						Spew("        Go 4");

						me = GetEntity("eb04");
						me.saved_mypath = "endBattle04";
						me.saved_idtag = 4;
						me.Delay( 14, 10 );
						saved_Occupied4 = 1;
					}
					return;
				}
				case 5
				{
					if( saved_Occupied5 = 0 )
					{
						Spew("        Go 5");

						me = GetEntity("eb05");
						me.saved_mypath = "endBattle05";
						me.saved_idtag = 5;
						me.Delay( 6, 10 );
						saved_Occupied5 = 1;
					}
					return;
				}
			}
		}
		Spew("<-- SpawnFinalWave()");
	}]

	SpawnBomberWave[ ()
	{
		Spew("--> SpawnBomberWave()");

		// adjust counters
		saved_NumBombWaves = toInt( saved_NumBombWaves + 1 );
		saved_NumDeadPlanes = 0;

		if( saved_NumBombWaves < 4 )
		{
			saved_EnableFinalWave = 1;
			SpawnFinalWave("all");

			// create 3 planes
			for i = 0 to 3
			{
				dBase = 30;
				spacing = 10;
				dTimer = (dBase + (i * spacing));
				fly = CreateEntity( 191, 0, 0, 0 );
				fly.Delay( dTimer, 10 );
			}

			GetEntity("sarge").Delay((dBase-7), 50);
		}
		else
		{
			Spew("        *** MAKE FINAL ESCAPE ***");
			ObjectiveComplete(3);
			SetObjectiveActive( 4, true );
			FinalEscapeSequence();
		}

		Spew("   <-- SpawnBomberWave()");
	}]

	CheckBomberRunOver[ ()
	{
		Spew("--> CheckBomberRunOver()");
		Spew("        bombWaves:   " # saved_NumBombWaves);
		Spew("        deadPlanes:  " # saved_NumDeadPlanes);

		if( saved_NumDeadPlanes > 2)
		{
			Spew("        *** This bombing wave is complete ***");
			SpawnBomberWave();
		}
	}]

	FinalEscapeSequence[ ()
	{
		saved_EnableEscape = 1;

		Sgt = GetEntity("sarge");
		Sgt.SetState_Idle();
		Sgt.TurnTo(Level.GetPlayer());
		Sgt.PlayAnimation(29);
	}]

	SlaughterAll[ ()
	{
		saved_EnableFinalWave = 0;

		dude = GetEntity("eb01"); if( not dude.IsDead() ){ dude.Kill(); }
		dude = GetEntity("eb02"); if( not dude.IsDead() ){ dude.Kill(); }
		dude = GetEntity("eb03"); if( not dude.IsDead() ){ dude.Kill(); }
		dude = GetEntity("eb04"); if( not dude.IsDead() ){ dude.Kill(); }
		dude = GetEntity("eb05"); if( not dude.IsDead() ){ dude.Kill(); }
	}]

	Spew[ (message)
	{
		if( debug_spam > 0 )
		{
			Log(message);
		}
	}]
}